﻿-- Creating table 'PL_LinkViewers'
CREATE TABLE [dbo].[PL_LinkViewers] (
    [LinkID] int  NOT NULL,
    [PrincipalID] int  NOT NULL
);
GO

-- Creating primary key on [LinkID], [PrincipalID] in table 'PL_LinkViewers'
ALTER TABLE [dbo].[PL_LinkViewers]
ADD CONSTRAINT [PK_PL_LinkViewers]
    PRIMARY KEY CLUSTERED ([LinkID], [PrincipalID] ASC);
GO

-- Creating foreign key on [LinkID] in table 'PL_LinkViewers'
ALTER TABLE [dbo].[PL_LinkViewers]
ADD CONSTRAINT [FK_PL_LinkPL_LinkViewer]
    FOREIGN KEY ([LinkID])
    REFERENCES [dbo].[PL_Link]
        ([LinkID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PrincipalID] in table 'PL_LinkViewers'
ALTER TABLE [dbo].[PL_LinkViewers]
ADD CONSTRAINT [FK_PrincipalPL_LinkViewer]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalPL_LinkViewer'
CREATE INDEX [IX_FK_PrincipalPL_LinkViewer]
ON [dbo].[PL_LinkViewers]
    ([PrincipalID]);
GO

-- Creating table 'PL_UserCategories'
CREATE TABLE [dbo].[PL_UserCategories] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [ViewId] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'PL_LinkUserCategories'
CREATE TABLE [dbo].[PL_LinkUserCategories] (
    [UserCategoryId] int  NULL,
    [LinkID] int  NULL,
    [Id] int IDENTITY(1,1) NOT NULL,
    [PrincipalID] int  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'PL_UserCategories'
ALTER TABLE [dbo].[PL_UserCategories]
ADD CONSTRAINT [PK_PL_UserCategories]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'PL_LinkUserCategories'
ALTER TABLE [dbo].[PL_LinkUserCategories]
ADD CONSTRAINT [PK_PL_LinkUserCategories]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [UserCategoryId] in table 'PL_LinkUserCategories'
ALTER TABLE [dbo].[PL_LinkUserCategories]
ADD CONSTRAINT [FK_PL_UserCategoryPL_LinkUserCategory]
    FOREIGN KEY ([UserCategoryId])
    REFERENCES [dbo].[PL_UserCategories]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_UserCategoryPL_LinkUserCategory'
CREATE INDEX [IX_FK_PL_UserCategoryPL_LinkUserCategory]
ON [dbo].[PL_LinkUserCategories]
    ([UserCategoryId]);
GO

-- Creating foreign key on [LinkID] in table 'PL_LinkUserCategories'
ALTER TABLE [dbo].[PL_LinkUserCategories]
ADD CONSTRAINT [FK_PL_LinkPL_LinkUserCategory]
    FOREIGN KEY ([LinkID])
    REFERENCES [dbo].[PL_Link]
        ([LinkID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_LinkPL_LinkUserCategory'
CREATE INDEX [IX_FK_PL_LinkPL_LinkUserCategory]
ON [dbo].[PL_LinkUserCategories]
    ([LinkID]);
GO

-- Creating foreign key on [PrincipalID] in table 'PL_LinkUserCategories'
ALTER TABLE [dbo].[PL_LinkUserCategories]
ADD CONSTRAINT [FK_PL_LinkUserCategoryPrincipal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_LinkUserCategoryPrincipal'
CREATE INDEX [IX_FK_PL_LinkUserCategoryPrincipal]
ON [dbo].[PL_LinkUserCategories]
    ([PrincipalID]);
GO

DROP TABLE [dbo].[PL_LinkOrder];
GO

-- Creating table 'PL_LinkOrder'
CREATE TABLE [dbo].[PL_LinkOrder] (
    [PrincipalID] int  NOT NULL,
    [ViewID] uniqueidentifier  NOT NULL,
    [Order] nvarchar(max)  NOT NULL,
    [UserCategoryId] int  NULL,
    [Id] int IDENTITY(1,1) NOT NULL
);
GO

-- Creating primary key on [Id] in table 'PL_LinkOrder'
ALTER TABLE [dbo].[PL_LinkOrder]
ADD CONSTRAINT [PK_PL_LinkOrder]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [UserCategoryId] in table 'PL_LinkOrder'
ALTER TABLE [dbo].[PL_LinkOrder]
ADD CONSTRAINT [FK_PL_UserCategoryPL_LinkOrder]
    FOREIGN KEY ([UserCategoryId])
    REFERENCES [dbo].[PL_UserCategories]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalPL_LinkOrder'
CREATE INDEX [IX_FK_PrincipalPL_LinkOrder]
ON [dbo].[PL_LinkOrder]
    ([PrincipalID]);
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_UserCategoryPL_LinkOrder'
CREATE INDEX [IX_FK_PL_UserCategoryPL_LinkOrder]
ON [dbo].[PL_LinkOrder]
    ([UserCategoryId]);
GO